package fr.asip.cps3.exemple.vues.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

import fr.asip.cps3.exemple.vues.composants.GridBagHelper;
import fr.asip.cps3.exemple.vues.ecrans.EcranUtil;

/**
 * Classe permettant de modliser la bote de dialogue de saisie d'un code avec affichage du nombre d'essais restant
 */
public class SaisieCodeNbEssais extends SaisieCode {

	private JLabel libelleNbEssais;
	private Color niveauCouleur;
	public static final Color NIVEAU_OK = new Color(70,128,37) /* Vert */;
	public static final Color NIVEAU_ATTENTION = new Color(173,145,33) /* Orange */;
	public static final Color NIVEAU_CRITIQUE = Color.RED;
	public static final Color NIVEAU_KO = Color.BLACK;
	protected JButton btnRecyclage;
	
	/**
	 * Constructeur
	 * @param fenetre fentre parente de la dialog
	 * @param numeroSerieCarte Numro de srie de la carte
	 * @param titre titre de la dialog
	 * @param conformiteCodePorteur Etat de conformit du code porteur
	 * @param numeroSerieCarte Numro de srie de la carte
	 * @param texteNbEssais texte d'avertissement pour le nombre d'essais
	 * @param niveauCouleur couleur du texte d'avertissement pour le nombre d'essais
	 */
	public SaisieCodeNbEssais(JFrame fenetre, String titre, String conformiteCode, String numeroSerieCarte, String texteNbEssais, Color niveauCouleur) {
		
		super(fenetre, titre, conformiteCode, numeroSerieCarte);
		this.niveauCouleur = niveauCouleur;
		libelleNbEssais = new JLabel(texteNbEssais);
		btnRecyclage = new JButton("Lancer le recyclage de la carte...");

	}

	/**
	 * Affiche la dialog
	 */
	public void affiche() {
		
		panel = new JPanel();
		
		// Cration du layout
		panel.setBorder(new EmptyBorder(0, 0, 0, 0));
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        
		libelleNbEssais.setForeground(niveauCouleur);
		if(niveauCouleur == NIVEAU_KO)
			libelleNbEssais.setFont(new Font("Arial",Font.BOLD,11));
		else
			libelleNbEssais.setFont(new Font("Arial",Font.ITALIC,11));
		

        
        // Ajout des composants
        GridBagHelper g = new GridBagHelper(panel);
        
        int i = 0;
        if(libelleConformite != null) {
        	g.ajoute(libelleConformite, EcranUtil.styleLibelleDialogLigneEntiere, 0, 0, 1, 2);
        	i++;
        }

        if(niveauCouleur != NIVEAU_KO)
        g.ajoute(libellePIN, EcranUtil.styleLibelleDialogLigneEntiere, i+0, 0, 1, 2);

        g.ajoute(libelleNbEssais, EcranUtil.styleLibelleDialogLigneEntiere, i+1, 0, 1, 2);

        if(niveauCouleur != NIVEAU_KO)
        	g.ajoute(codePorteur, EcranUtil.styleTexteDialog, i+2, 0, 1, 2);

        if(niveauCouleur == NIVEAU_KO)
        	g.ajoute(btnRecyclage, EcranUtil.styleBoutonDialogValider, i+3, 0, 1, 1);
        else
        	g.ajoute(btnValider, EcranUtil.styleBoutonDialogValider, i+3, 0, 1, 1);
    	g.ajoute(btnAnnuler, EcranUtil.styleBoutonDialogAnnuler, i+3, 1, 1, 1);

		d.getContentPane().add(panel,BorderLayout.CENTER);
		d.setTitle(titre);
		d.setModal(true);
		d.pack();
		
		// centrage de la dialog
        Rectangle r = fenetre.getBounds();
        int x = r.x + (r.width - d.getSize().width)/2;
        int y = r.y + (r.height - d.getSize().height)/2;
        d.setLocation(x, y);
		
		ActionListener ecouteur = new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				
				if(ae.getSource() == btnAnnuler) {
					choixUtilisateur = -1;
				} else if(ae.getSource() == btnRecyclage) {
					choixUtilisateur = 3;
				} else {
					code = codePorteur.getPassword();
					choixUtilisateur = 1;
				}
				d.dispose();
			}
		};

		btnRecyclage.addActionListener(ecouteur);
		btnValider.addActionListener(ecouteur);
		btnAnnuler.addActionListener(ecouteur);
		
		d.setVisible(true);		
				
		
	}
	
	/**
	 * Accesseur
	 * @return Code porteur
	 */
	public char[] getCode(){
		return code;
	}

	/**
	 * Accesseur
	 * @return Choix utilisateur
	 */
	public int getChoixUtilisateur(){
		return choixUtilisateur;
	}	
	
}